/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Operator;
import com.mckoi.database.TObject;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TransactionSystem;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IntegerIterator;
import com.mckoi.util.IntegerVector;

public final class PatternSearch {
    private static final char ZERO_OR_MORE_CHARS = '%';
    private static final char ONE_CHAR = '_';

    public static boolean testSearch(String pattern, String expression, boolean result) {
        System.out.print("Pattern:    ");
        System.out.println("'" + pattern + "'");
        System.out.print("Expression: ");
        System.out.println("'" + expression + "'");
        boolean tested_as = PatternSearch.fullPatternMatch(pattern, expression, '\\');
        System.out.print("Result:     ");
        System.out.print(tested_as);
        if (tested_as != result) {
            System.out.println(" *** FAILED, Expected: " + result + " ***");
        } else {
            System.out.println();
        }
        return tested_as;
    }

    public static void main(String[] args) {
        PatternSearch.testSearch("", "abc", false);
        PatternSearch.testSearch("%", "abc", true);
        PatternSearch.testSearch("a%", "abc", true);
        PatternSearch.testSearch("ab%", "abc", true);
        PatternSearch.testSearch("abc%", "abc", true);
        PatternSearch.testSearch("abcd%", "abc", false);
        PatternSearch.testSearch("abcd", "abc", false);
        PatternSearch.testSearch("abc", "abc", true);
        PatternSearch.testSearch("ab", "abc", false);
        PatternSearch.testSearch("a", "abc", false);
        PatternSearch.testSearch("a_", "abc", false);
        PatternSearch.testSearch("ab_", "abc", true);
        PatternSearch.testSearch("abc_", "abc", false);
        PatternSearch.testSearch("a_c", "abc", true);
        PatternSearch.testSearch("a%bc", "abc", true);
        PatternSearch.testSearch("a%c", "abc", true);
        PatternSearch.testSearch("%c", "abc", true);
        PatternSearch.testSearch("a_bc", "abc", false);
        PatternSearch.testSearch("__c", "abc", true);
        PatternSearch.testSearch("a__", "abc", true);
        PatternSearch.testSearch("a\\_\\_", "a__", true);
        PatternSearch.testSearch("a\\__", "a__", true);
        PatternSearch.testSearch("a\\__", "a_b", true);
        PatternSearch.testSearch("\\___", "_ab", true);
        PatternSearch.testSearch("\\_\\__", "_ab", false);
        PatternSearch.testSearch("\\_\\__", "__b", true);
        PatternSearch.testSearch("\\%ab", "%ab", true);
        PatternSearch.testSearch("ab\\%", "ab%", true);
        PatternSearch.testSearch("cab\\%", "cab", false);
        PatternSearch.testSearch("cab%", "cab", true);
    }

    private static boolean isWildCard(char ch) {
        return ch == '_' || ch == '%';
    }

    public static boolean fullPatternMatch(String pattern, String str, char escape_char) {
        String st;
        StringBuffer start = new StringBuffer();
        String rezt = null;
        int len = pattern.length();
        boolean last_escape_char = false;
        for (int i = 0; i < len && rezt == null; ++i) {
            char c = pattern.charAt(i);
            if (last_escape_char) {
                last_escape_char = false;
                start.append(c);
                continue;
            }
            if (c == escape_char) {
                last_escape_char = true;
                continue;
            }
            if (PatternSearch.isWildCard(c)) {
                rezt = pattern.substring(i);
                continue;
            }
            start.append(c);
        }
        if (rezt == null) {
            rezt = "";
        }
        if (str.startsWith(st = new String(start))) {
            String str_rezt = str.substring(st.length());
            if (rezt.length() > 0) {
                return PatternSearch.patternMatch(rezt, str_rezt, escape_char);
            }
            return str_rezt.length() == 0;
        }
        return false;
    }

    public static boolean patternMatch(String pattern, String expression, char escape_char) {
        if (pattern.charAt(0) == '_') {
            int i = 1;
            boolean finished = i >= pattern.length() || expression.length() < 1;
            boolean last_was_escape = false;
            int checked = 0;
            while (!finished) {
                char c = pattern.charAt(i);
                if (!last_was_escape && c == escape_char) {
                    last_was_escape = true;
                    if (i >= expression.length()) {
                        return false;
                    }
                    ++i;
                } else if (last_was_escape || !PatternSearch.isWildCard(c)) {
                    last_was_escape = false;
                    if (i >= expression.length() || c != expression.charAt(i)) {
                        return false;
                    }
                    ++i;
                    ++checked;
                } else {
                    return PatternSearch.patternMatch(pattern.substring(i), expression.substring(i), escape_char);
                }
                finished = i >= pattern.length();
            }
            int real_pattern_length = 0;
            int sz = pattern.length();
            for (int n = 0; n < sz; ++n) {
                if (pattern.charAt(n) != escape_char) {
                    ++real_pattern_length;
                    continue;
                }
                ++n;
            }
            return real_pattern_length == expression.length();
        }
        if (pattern.length() == 1) {
            return true;
        }
        StringBuffer next_string = new StringBuffer();
        int i = 1;
        boolean finished = i >= pattern.length();
        boolean last_was_escape = false;
        while (!finished) {
            char next_char = pattern.charAt(i);
            if (!last_was_escape && next_char == escape_char) {
                last_was_escape = true;
                if (++i < pattern.length()) continue;
                finished = true;
                continue;
            }
            if (last_was_escape || !PatternSearch.isWildCard(next_char)) {
                last_was_escape = false;
                next_string.append(next_char);
                if (++i < pattern.length()) continue;
                finished = true;
                continue;
            }
            finished = true;
        }
        String find_string = new String(next_string);
        if (i >= pattern.length()) {
            return expression.endsWith(find_string);
        }
        int find_str_length = find_string.length();
        int str_index = expression.indexOf(find_string, 0);
        while (str_index != -1) {
            boolean matched = PatternSearch.patternMatch(pattern.substring(1 + find_str_length), expression.substring(str_index + find_str_length), escape_char);
            if (matched) {
                return true;
            }
            str_index = expression.indexOf(find_string, str_index + 1);
        }
        return false;
    }

    static IntegerVector search(Table table, int column, String pattern) {
        return PatternSearch.search(table, column, pattern, '\\');
    }

    static IntegerVector search(Table table, int column, String pattern, char escape_char) {
        String post_pattern;
        IntegerVector search_case;
        TType col_type = table.getDataTableDef().columnAt(column).getTType();
        if (!(col_type instanceof TStringType)) {
            throw new Error("Unable to perform a pattern search on a non-String type column.");
        }
        TStringType col_string_type = (TStringType)col_type;
        StringBuffer pre_pattern = new StringBuffer();
        int i = 0;
        boolean finished = i >= pattern.length();
        boolean last_is_escape = false;
        while (!finished) {
            char c = pattern.charAt(i);
            if (last_is_escape) {
                last_is_escape = true;
                pre_pattern.append(c);
                continue;
            }
            if (c == escape_char) {
                last_is_escape = true;
                continue;
            }
            if (!PatternSearch.isWildCard(c)) {
                pre_pattern.append(c);
                if (++i < pattern.length()) continue;
                finished = true;
                continue;
            }
            finished = true;
        }
        if (i >= pattern.length()) {
            TObject cell = new TObject(col_type, pattern);
            return table.selectRows(column, Operator.get("="), cell);
        }
        if (pre_pattern.length() == 0 || col_string_type.getLocale() != null) {
            search_case = table.selectAll(column);
            post_pattern = pattern;
        } else {
            String lower_bounds = new String(pre_pattern);
            int next_char = pre_pattern.charAt(i - 1) + '\u0001';
            pre_pattern.setCharAt(i - 1, (char)next_char);
            String upper_bounds = new String(pre_pattern);
            post_pattern = pattern.substring(i);
            TObject cell_lower = new TObject(col_type, lower_bounds);
            TObject cell_upper = new TObject(col_type, upper_bounds);
            search_case = table.selectRows(column, cell_lower, cell_upper);
        }
        int pre_index = i;
        BlockIntegerList i_list = new BlockIntegerList(search_case);
        IntegerIterator iterator = i_list.iterator(0, i_list.size() - 1);
        while (iterator.hasNext()) {
            boolean pattern_matches = false;
            TObject cell = table.getCellContents(column, iterator.next());
            if (!cell.isNull()) {
                String expression = cell.getObject().toString();
                expression = expression.substring(pre_index);
                pattern_matches = PatternSearch.patternMatch(post_pattern, expression, escape_char);
            }
            if (pattern_matches) continue;
            iterator.remove();
        }
        return new IntegerVector(i_list);
    }

    static boolean regexMatch(TransactionSystem system, String pattern, String value) {
        if (pattern.startsWith("/")) {
            int end = pattern.lastIndexOf(47);
            String pat = pattern.substring(1, end);
            String ops = pattern.substring(end + 1);
            return system.getRegexLibrary().regexMatch(pat, ops, value);
        }
        return system.getRegexLibrary().regexMatch(pattern, "", value);
    }

    static IntegerVector regexSearch(Table table, int column, String pattern) {
        if (pattern.startsWith("/")) {
            int end = pattern.lastIndexOf(47);
            String pat = pattern.substring(1, end);
            String ops = pattern.substring(end + 1);
            return table.getDatabase().getSystem().getRegexLibrary().regexSearch(table, column, pat, ops);
        }
        return table.getDatabase().getSystem().getRegexLibrary().regexSearch(table, column, pattern, "");
    }
}

